#{{uc_id}} *{
  box-sizing:border-box;
}
#{{uc_id}}{
  position:relative;
  overflow:hidden;
  direction:{{rtl}}!important;
}

#{{uc_id}} .ue-link{
  display:block;
  position:absolute;
  left:0;
  right:0;
  bottom:0;
  top:0;
}

#{{uc_id}} .image-caption-reveal-on-hover{
  transition:{{transition_duration}}ms;
  width:100%;
  background-color:lightgray;
  background-image:url({{image}});
  background-size:cover;
  position:absolute;
  top:0;
  left:0;
  bottom:0;
  right:0;
  transform:scale(100%,100%);
}

#{{uc_id}} .icroh-caption{
  transition:{{transition_duration}}ms;
  position:absolute;
  color:white;
  width:100%;
}

#{{uc_id}} .icroh-text{
  display:none;
}
#{{uc_id}}.ue_crcb_active .icroh-text{
  display:block;
}
{% if show_content_on_breakpoint == "true" %}
  @media only screen and (max-width: {{breakpoint}}px) {
    #{{uc_id}} .icroh-text{
      display:block!important;
    }
  }
{% endif %}

{% if show_badge == "true" %}
  #{{uc_id}} .ue-badge-wrapper{
    {% if badge_placement == "left" %}
      transform: rotate(0deg);
      right:unset;
      left:0;
    {% elseif badge_placement == "right" %}
      transform: rotate(90deg);
      right:0;
      left:unset;
    {% endif %}
    position:absolute;
    top:0;
    z-index: 3;
    overflow:hidden;
  }
  #{{uc_id}} .ue-badge{
    width: 150%;
    display:inline-flex;
    justify-content:center;
    align-items:center;
  }
  #{{uc_id}} .ue-badge-icon{
    display:inline-flex;
    justify-content:center;
    align-items:center;
  }
  .ue_badge
  {
    font-size:10px;
    line-height:1em;
  }
{% endif %}

{% if show_title == "true" %}
.icroh-title{
  font-size:18px;
}
{% endif %}