<?php
/**
 * Plugin Name: Elementor Service Cards
 * Plugin URI:  https://yourwebsite.com/plugins/elementor-service-cards
 * Description: A custom Elementor widget to showcase service cards with multiple layout styles, HTML support in descriptions, and customizable button text.
 * Version:     1.0.0
 * Author:      LuvCite Technology
 * Author URI:  https://luvcite.com
 * License:     GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: elementor-service-cards
 * Domain Path: /languages
 *
 * Elementor tested up to: 3.20.0
 * Elementor Pro tested up to: 3.20.0
 * Requires at least: 5.8
 * Requires PHP: 7.4
 */


function esc_register_service_cards_widget($widgets_manager) {
    require_once(__DIR__ . '/widgets/widget-service-cards.php');
    $widgets_manager->register(new \Elementor_Service_Cards_Widget());
}
add_action('elementor/widgets/register', 'esc_register_service_cards_widget');

function esc_enqueue_styles() {
    wp_enqueue_style('service-cards-css', plugin_dir_url(__FILE__) . 'css/service-cards.css');
}
add_action('wp_enqueue_scripts', 'esc_enqueue_styles');
