<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;

class Elementor_Service_Cards_Widget extends Widget_Base {
    public function get_name() {
        return 'service_cards';
    }

    public function get_title() {
        return __('Service Cards', 'plugin-name');
    }

    public function get_icon() {
        return 'eicon-posts-grid';
    }

    public function get_categories() {
        return ['general'];
    }

    protected function _register_controls() {
        $this->start_controls_section('section_content', [
            'label' => __('Services', 'plugin-name'),
        ]);

        $this->add_control('layout', [
            'label' => __('Layout Style', 'plugin-name'),
            'type' => Controls_Manager::SELECT,
            'default' => 'style1',
            'options' => [
                'style1' => __('Style 1', 'plugin-name'),
                'style2' => __('Style 2', 'plugin-name'),
            ],
        ]);

        $repeater = new Repeater();

        $repeater->add_control('image', [
            'label' => __('Image', 'plugin-name'),
            'type' => Controls_Manager::MEDIA,
        ]);

        $repeater->add_control('title', [
            'label' => __('Title', 'plugin-name'),
            'type' => Controls_Manager::TEXT,
        ]);

        $repeater->add_control('description', [
            'label' => __('Description', 'plugin-name'),
            'type' => Controls_Manager::TEXTAREA,
        ]);

        $repeater->add_control('price', [
            'label' => __('Price', 'plugin-name'),
            'type' => Controls_Manager::TEXT,
        ]);

        $repeater->add_control('duration', [
            'label' => __('Duration', 'plugin-name'),
            'type' => Controls_Manager::TEXT,
        ]);
        
        $this->add_control('button_text', [
            'label' => __('Button Text', 'plugin-name'),
            'type' => Controls_Manager::TEXT,
            'default' => __('Select', 'plugin-name'), // Default button text
            'placeholder' => __('Enter Button Text', 'plugin-name'),
        ]);

        $repeater->add_control('button_link', [
            'label' => __('Button Link', 'plugin-name'),
            'type' => Controls_Manager::URL,
        ]);

        $this->add_control('services', [
            'label' => __('Service Items', 'plugin-name'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [],
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $layout = $settings['layout'];
        $button_text = isset($settings['button_text']) ? $settings['button_text'] : __('Select', 'plugin-name'); // Get the button text
        ?>
        <div class="services-container <?php echo esc_attr($layout); ?>">
            <?php foreach ($settings['services'] as $service): ?>
                <?php if ($layout === 'style1'): ?>
                    <div class="service-card style1">
                        <div class="service-image">
                            <img src="<?php echo esc_url($service['image']['url']); ?>" alt="">
                        </div>
                        <div class="service-content">
                            <div>
                                <div class="service-title"><?php echo esc_html($service['title']); ?></div>
                                <div class="service-desc"><?php echo wp_kses_post($service['description']); ?></div> <!-- Updated -->
                            </div>
                            <div class="service-meta">
                                <span><?php echo esc_html($service['price']); ?></span>
                                <span><?php echo esc_html($service['duration']); ?></span>
                            </div>
                            <a href="<?php echo esc_url($service['button_link']['url']); ?>" class="select-btn" target="_blank" rel="nofollow"><?php echo esc_html($button_text); ?></a> <!-- Updated -->
                        </div>
                    </div>
                <?php else: ?>
                    <div class="service-card style2">
                        <div class="service-image">
                            <img src="<?php echo esc_url($service['image']['url']); ?>" alt="">
                        </div>
                        <div class="price-badge"><?php echo esc_html($service['price']); ?></div>
                        <div class="service-content">
                            <div class="service-title"><?php echo esc_html($service['title']); ?></div>
                            
                            <div class="service-desc"><?php echo wp_kses_post($service['description']); ?></div> <!-- Updated -->
                            <div class="duration"><?php echo esc_html($service['duration']); ?></div>
                            <a href="<?php echo esc_url($service['button_link']['url']); ?>" class="select-btn" target="_blank" rel="nofollow"><?php echo esc_html($button_text); ?></a> <!-- Updated -->
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
        <?php
    }
}
