/* vars */
:root {
  --regular-transition: cubic-bezier(0.445, 0.05, 0.55, 0.95);
  --hover-transition: cubic-bezier(0.23, 1, 0.32, 1);
}
/* end vars */

#{{uc_id}}{
  min-height: 1px;
  cursor: pointer;
  position: relative;
  transform: perspective(800px);
  transform-style: preserve-3d;
}

#{{uc_id}} .ue-3d-content-card-wrap{ 
  overflow: hidden;
  transition: .3s var(--regular-transition);
  position: relative;
  display: flex;
  will-change: transform; 
}

#{{uc_id}}:hover .ue-3d-content-card-wrap{
  transition: 0.6s var(--hover-transition), box-shadow 1s var(--hover-transition);
}

#{{uc_id}} .ue-3d-content-card-img{
  will-change: transform; 
  transition: .3s var(--regular-transition), opacity 1s var(--regular-transition);
  position: absolute;
  top: -{{image_depth_nounit}}px;
  left: -{{image_depth_nounit}}px;
  right: -{{image_depth_nounit}}px;
  bottom: -{{image_depth_nounit}}px;
  z-index: -1;
}

#{{uc_id}}:hover .ue-3d-content-card-img{
  transition: 0.6s var(--hover-transition), opacity 5s var(--hover-transition);
}

#{{uc_id}} .ue-3d-content-card-overlay{
  position: absolute;
  width: 100%;
  height: 100%;
  left: 0;
  top: 0;
  z-index: 0;
  transition: .3s var(--regular-transition);
}

#{{uc_id}} .ue-3d-content-card-content{
  transition: 0.6s cubic-bezier(0.215, 0.61, 0.355, 1);
  will-change: transform; 
}

#{{uc_id}}:hover .ue-3d-content-card-content{
  transition: 0.6s var(--hover-transition);
}

#{{uc_id}} .ue-3d-content-card-icon{
  line-height: 1;
}

#{{uc_id}} .ue-3d-content-card-button{
  transition: all .3s var(--regular-transition);
  display: inline-block;
}