<?php
/*
Plugin Name: Quote Request Form
Description: Displays a "Request a Quote" button that opens a popup form and emails the inquiry to a client email set in the admin menu.
Version: 1.2
Author: Luvcite
*/

// ===== Enqueue CSS & JS inline =====
function qrf_enqueue_scripts() {
    // Inline CSS
    $css = "
    .uqr-btn {
        background:#00a9e0;color:#fff;padding:14px 28px;border:none;
        border-radius:30px;font-size:16px;cursor:pointer;
    }
    .uqr-popup {
        display:none;position:fixed;z-index:9999;left:0;top:0;width:100%;
        height:100%;background:rgba(0,0,0,0.6);
    }
    .uqr-popup-content {
        background:#fff;margin:8% auto;padding:30px;width:90%;max-width:400px;
        border-radius:10px;position:relative;
    }
    .uqr-popup-content input,.uqr-popup-content textarea {
        width:100%;padding:10px;margin:10px 0;border:1px solid #ccc;
        border-radius:5px;
    }
    .uqr-popup-content button[type=submit] {
        background:#00a9e0;color:#fff;padding:10px 20px;border:none;
        border-radius:5px;cursor:pointer;
    }
    .uqr-close {
        position:absolute;top:10px;right:15px;font-size:24px;cursor:pointer;
    }
    .uqr-success{color:green;margin-top:10px;display:none;}
    .uqr-error{color:red;margin-top:10px;display:none;}
    ";
    wp_register_style('qrf-inline-style', false);
    wp_enqueue_style('qrf-inline-style');
    wp_add_inline_style('qrf-inline-style', $css);

    // Inline JS
    $js = "
    jQuery(document).ready(function($){
        $('.uqr-btn').on('click', function(){
            $('.uqr-popup').fadeIn();
        });
        $('.uqr-close').on('click', function(){
            $('.uqr-popup').fadeOut();
        });
        $('.uqr-form').on('submit', function(e){
            e.preventDefault();
            var formData = $(this).serialize();
            $.post('".admin_url('admin-ajax.php')."', {
                action: 'uqr_submit_form',
                ...Object.fromEntries(new URLSearchParams(formData))
            }, function(response){
                if(response === 'success'){
                    $('.uqr-form').hide();
                    $('.uqr-success').show();
                } else {
                    $('.uqr-error').show();
                }
            });
        });
    });
    ";
    wp_register_script('qrf-inline-script', '', [], false, true);
    wp_enqueue_script('qrf-inline-script');
    wp_add_inline_script('qrf-inline-script', $js);
}
add_action('wp_enqueue_scripts', 'qrf_enqueue_scripts');

// ===== Shortcode =====
function qrf_form_shortcode() {
    ob_start(); ?>
    <button class="uqr-btn">REQUEST A QUOTE</button>
    <div class="uqr-popup">
        <div class="uqr-popup-content">
            <span class="uqr-close">&times;</span>
            <h2>Request a Quote</h2>
            <form class="uqr-form">
                <input type="text" name="name" placeholder="Name" required>
                <input type="email" name="email" placeholder="Email" required>
                <input type="text" name="subject" placeholder="Subject" required>
                <textarea name="message" placeholder="Message" required></textarea>
                <button type="submit">Submit</button>
            </form>
            <div class="uqr-success">Thank you! Your request has been sent.</div>
            <div class="uqr-error">Sorry, email could not be sent. Please try again.</div>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('unique_quote_form', 'qrf_form_shortcode');

// ===== Admin menu to set client email =====
function qrf_admin_menu() {
    add_menu_page(
        'Request a Quote Settings',
        'REQUEST A QUOTE',
        'manage_options',
        'qrf-settings',
        'qrf_settings_page',
        'dashicons-email',
        26
    );
}
add_action('admin_menu', 'qrf_admin_menu');

function qrf_settings_page() {
    if (!current_user_can('manage_options')) return;
    if (isset($_POST['qrf_client_email'])) {
        update_option('qrf_client_email', sanitize_email($_POST['qrf_client_email']));
        echo '<div class="updated"><p>Client email updated successfully.</p></div>';
    }
    $email = get_option('qrf_client_email', get_option('admin_email'));
    ?>
    <div class="wrap">
        <h1>Request a Quote Settings</h1>
        <form method="post">
            <label for="qrf_client_email">Client Email:</label>
            <input type="email" name="qrf_client_email"
                   value="<?php echo esc_attr($email); ?>" required style="width:300px;">
            <p class="submit"><input type="submit" class="button-primary" value="Save Email"></p>
        </form>
    </div>
    <?php
}

// ===== AJAX form handler =====
function qrf_handle_form() {
    $name    = sanitize_text_field($_POST['name']);
    $email   = sanitize_email($_POST['email']);
    $subject = sanitize_text_field($_POST['subject']);
    $message = sanitize_textarea_field($_POST['message']);

    $to = get_option('qrf_client_email', get_option('admin_email'));
    $from_email = 'no-reply@' . preg_replace('/^www\\./', '', $_SERVER['SERVER_NAME']);
    $headers = array(
        'Content-Type: text/html; charset=UTF-8',
        'From: '.get_bloginfo('name').' <'.$from_email.'>'
    );
    $body = "<strong>Name:</strong> $name<br><strong>Email:</strong> $email<br>"
          . "<strong>Subject:</strong> $subject<br><strong>Message:</strong><br>$message";

    if (wp_mail($to, 'New Quote Request: ' . $subject, $body, $headers)) {
        echo 'success';
    } else {
        echo 'mail_failed';
    }
    wp_die();
}
add_action('wp_ajax_uqr_submit_form', 'qrf_handle_form');
add_action('wp_ajax_nopriv_uqr_submit_form', 'qrf_handle_form');
