#{{uc_id}}.uc-ajax-search-wrapper{
	
    position:relative;
    display:flex;
    width:100%;
}
#{{uc_id}} .uc-ajax-search__title
{
  display:block;
}

#{{uc_id}} .uc-search-item__link-title b.uc-capitalized,
#{{uc_id}} .uc-search-item__link-title:not(b.uc-capitalized)::first-letter {
  text-transform: none;
}

#{{uc_id}} .uc-ajax-search-wrapper-inside
{
  width:100%;
}

#{{uc_id}}.uc-ajax-search-wrapper span{
}

#{{uc_id}}.uc-ajax-search-wrapper input{
  width:100%;
}


#{{uc_id}} .uc-ajax-search__input-wrapper-inner
{
  position:relative;
  flex-grow:1;
}

#{{uc_id}} .uc-ajax-search__items{
	position:absolute;
    left:0px;
    width:100%;
  	z-index:999999;
    overflow:hidden;
}

#{{uc_id}} .uc-search-item__link{
	display:flex;
    align-items:center;
    gap:10px;
}


#{{uc_id}} .uc-search-item__link-title{
  display:block;
}

    {% if pagination_position == "before" %}
#{{uc_id}} .uc-pagination-footer{
  display:none;
}
{% endif %}
  {% if pagination_position == "after" %}
#{{uc_id}} .uc-pagination-header{
  display:none;
}
{% endif %}

#{{uc_id}} .uc-search-item__link-image{
    display:block;
    flex-grow:0;
    flex-shrink:0;
} 

#{{uc_id}} .uc-ajax-search__input-wrapper{
	position:relative;
    display:flex;
    align-items:center;
    justify-content:center;
}

#{{uc_id}} .uc-pagination-panel{
  	width: 100%;
	overflow: hidden;
  	transition: width .5s;
}

#{{uc_id}} .uc-ajax-search-product-card{
  	text-align: center;
    flex-direction: column;
    gap: 10px;
  	display: flex;
}

#{{uc_id}} .uc-ajax-search-product-card-img img{
  	margin: 0 auto;
}

#{{uc_id}} .uc-ajax-search__items{
	display: flex;
}

#{{uc_id}} .uc-search-item{
	transition: background-color .3s;
}

#{{uc_id}} .uc-search-item.uc-selected{
	background-color: #ccc;
}


#{{uc_id}} .uc-pagination-list{
	display: flex;
  	flex-wrap: nowrap;
  	width: 100%;
  	transition: transform .3s;
}

#{{uc_id}} .uc-pagination-list-inner{
	flex: 0 0 100%;
  	max-width: 100%;
}

#{{uc_id}} .uc-pagination-header{
	display: flex;
  	justify-content: space-between;
  	align-items: center;
  	direction: ltr; 
    {% if show_pagination == "false" %}
          display: none;
    {% endif %}
}

#{{uc_id}} .uc-ajax-search-pages{
	display: flex;
  	gap: 5px;
}


#{{uc_id}} .uc-ajax-search-navigation-panel{
	display: flex;
  	gap: 15px;
  	justify-content: space-between;
}

#{{uc_id}} .uc-ajax-arrows{
	display: flex;
  	justify-content: space-between;
  	gap: 10px;
  	cursor: pointer;
}

#{{uc_id}} .uc-ajax-arrows .uc-inactive{
	opacity: .5;
}

#{{uc_id}} .uc-ajax-arrow-left{
	position: relative;
}

#{{uc_id}} .uc-ajax-arrow-left::before{
	font-family: "Font Awesome 5 Free";
    content: "\{{left_font_awesome|raw}}";
    font-weight: 900;
    line-height:1em;
  	display: inline-flex;
}

#{{uc_id}} .uc-ajax-arrow-right::before{
	font-family: "Font Awesome 5 Free";
    content: "\{{right_font_awesome|raw}}";
    font-weight: 900;
    line-height:1em;
  	display: inline-flex;
}

#{{uc_id}} .uc-ajax-search__btn
{
  display:flex;
  align-items:center;
  justify-content:center;
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .uc-ajax-search__btn.uc-inactive{
	cursor: default;
  	opacity: 0.7;
	pointer-events: none;
}

#{{uc_id}} .uc-ajax-search__btn_icon
{
  line-height:1em;
}

#{{uc_id}} .uc-ajax-search__btn svg
{
  height:1em;
  width:1em;
}

#{{uc_id}}.uc-loading .uc-ajax-search__spinner__loader-wrapper{
	display:flex !important;
}

#{{uc_id}} .uc-ajax-search__error{
	color:red;
    padding-top:15px;
}

#{{uc_id}} .uc-ajax-search__spinner__loader-wrapper{
  position:absolute;
  top:50%;
  transform:translateY(-50%);
  inset-inline-end: 15px;
  height: 100%;
  align-items: center;
  justify-content: center;
}

#{{uc_id}} .uc-ajax-search__spinner {
  animation: ajaxsearchrotate 2s linear infinite;
  z-index: 2;
  width: 25px;
  height: 25px;
}

#{{uc_id}} .uc-ajax-search__spinner-path {
  stroke-linecap: round;
  animation: ajaxsearchdash 1.5s ease-in-out infinite;
}

#{{uc_id}} .uc-pagination-list-inner
{
  display:grid;
}

#{{uc_id}} ::-webkit-input-placeholder { /* Edge */
  color: {{search_placeholder_color}};
}

#{{uc_id}} :-ms-input-placeholder { /* Internet Explorer 10-11 */
  color: {{search_placeholder_color}};
}

#{{uc_id}} ::placeholder {
  color: {{search_placeholder_color}};
}

#{{uc_id}} .uc-ajax-search__input.uc-active{
 caret-color: unset;
}

#{{uc_id}} .uc-ajax-search__input{
 caret-color: transparent;
}


/* input type: number - hide arrows in Chrome, Safari, Edge, Opera */
#{{uc_id}} ::-webkit-outer-spin-button,
#{{uc_id}} ::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

/* input type: number - hide arrows in Firefox */
#{{uc_id}} .uc-search-item__link-count-buttons__number {
  -moz-appearance: textfield;
}

#{{uc_id}} .uc-search-item__link-count-buttons{
	display: flex;
  	justify-content: center;
}

#{{uc_id}} .uc-search-item__link-count-buttons button{
	display: flex;
  	justify-content: center;
  	align-items: center;
}

#{{uc_id}} .uc-search-item__link-count-buttons input{
	max-width: 100px;
}

#{{uc_id}} .uc-button-addcart,
#{{uc_id}} .added_to_cart,
#{{uc_id}} .uc-search-item__product-page{
	text-align: center;
    text-decoration: none;
    text-transform: none;
	transition: all 0.25s ease-in-out;
}
#{{uc_id}} .uc-button-addcart,
#{{uc_id}} .added_to_cart{
	display: {{button_style}};
}
#{{uc_id}} .uc-search-item__product-page{
	display: {{button_style_product_page}};
}

#{{uc_id}} .ue-inner-btn-wrapper
{
  display:flex;
  align-items:center;
  justify-content:center;
  position: relative;
}


#{{uc_id}} .uc-button-addcart.added
{
  display:none;
}

#{{uc_id}} span.add-to-cart__loader{
  	position: absolute;
  	right: 0;
  	top: 50%;
  	transform: translate(0, -50%);
  	line-height: 1em;
}

#{{uc_id}} .add_to_cart_button.loading span.add-to-cart__loader{
	display: inline-block !important;
}

{% if show_image_in_results == "false" %}  
  #{{uc_id}} .uc-pagination-panel .uc-search-item__link-image{
	display: none;
  }
{% endif %}


{% if show_price == "false" %}  
  #{{uc_id}} .uc-ajax-search-product-card .uc-ajax-search-product-card-price{
	display: none;
  }
{% endif %}

{% if show_product_card_image == "false" %}  
  #{{uc_id}} .uc-ajax-search-product-card .uc-ajax-search-product-card-img{
	display: none;
  }
{% endif %}

{% if show_product_title == "false" %}  
  #{{uc_id}} .uc-ajax-search-product-card .uc-ajax-search-product-card-title{
	display: none;
  }
{% endif %}
#{{uc_id}} .uc-pagination-panel .uc-search-item-wrapper
{
  width:100%;
  display:flex;
  text-align:left;
  justify-content:space-between;
 gap:8px;
}

#{{uc_id}} .uc-pagination-panel .uc-search-item__link-price{
  display:flex;
  gap:8px;
}

{% if show_price_in_results == "false" %}  
  #{{uc_id}} .uc-pagination-panel .uc-search-item__link-price{
	display: none;
  }
{% endif %}

#{{uc_id}}  .uc-pagination-panel .uc-search-item__link-price>div
{
  display:flex;
}
@keyframes ajaxsearchrotate {
  100% {
    transform: rotate(360deg);
  }
}

@keyframes ajaxsearchdash {
  0% {
    stroke-dasharray: 1, 150;
    stroke-dashoffset: 0;
  }
  50% {
    stroke-dasharray: 90, 150;
    stroke-dashoffset: -35;
  }
  100% {
    stroke-dasharray: 90, 150;
    stroke-dashoffset: -124;
  }
}

{% if hide_card_on_breakpoint == "true" %}

  @media (max-width: {{hide_card_breakpoint}}px) {
    #{{uc_id}} .uc-ajax-search-product-card{
      display: none;
    }
    #{{uc_id}} .uc-pagination-panel{
      width: 100% !important;
    }
    #{{uc_id}} .uc-search-item:first-child .uc-search-item__link{
      border-top: none;
    }
  }

{% endif %}