{# twig vars #}{##}
{% set urlImage2 = ucfunc("get_woo_image2",item.products.id,item.products.image_size) %}

{% set custom_field_value = ucfunc("get_post_custom_field", item.products.id, custom_field_name) %}

{% set ratingElem %}
<div class="product-rating">
  {% for staritem in item.products.woo_rating_stars %}                
  	<i class="{{staritem.class}}"></i>
  {% endfor %}
</div>
{% endset %}{# end ratingElem #}{##}

{% set defaultImageElem %}
  {% if default_image is empty %}
    <img src="{{uc_assets_url}}/placeholder.jpg" alt="{{item.products.image_alt}}">
  {% else %}
    <img src="{{default_image}}" {{default_image_attributes|raw}}>
  {% endif %}
{% endset %}{# end defaultImageElem #}{##}

{% set labelElem %}
<div class="ue_woocommerce_product_label ue_woocommerce_product_carousel_sale_label">
  {{sale_label|raw}} 
  {% if show_sale_precent_in_label == "true" %}
    {{item.products.woo_discount_percent}}%
  {% endif %}
  {{sale_label_end_text|raw}}
</div>
{% endset %}{# end labelElem #}{##}

{% set outOfStockLabelElem %}
  <div class="ue_woocommerce_product_label ue_woocommerce_product_grid_out_of_stock_label">{{out_of_stock_text|raw}}</div>
{% endset %}{# end outOfStockLabelElem #}{##}

{% set labelsElem %}
  {% if item.products.woo_stock_status == "outofstock" %}
    {{outOfStockLabelElem}}
  {% else %}
    {% if item.products.woo_sale_price is not empty %}
      {{labelElem}}
    {% endif %}	
  {% endif %}
{% endset %}{# end labelsElem #}{##}

{% set textAfterPriceElem %}
  <span class="ue-text-after-price">{{text_after_prices|raw}}</span>
{% endset %}{# end textAfterPriceElem #}{##}

{% set regularProductRegularPriceElem %}
  {% if replace_0_price_by_text == "true" and item.products.woo_regular_price != "" %}
    {{item.products.woo_regular_price|wc_price|raw}}{% if show_text_after_prices == "true" %}{{textAfterPriceElem}}{% endif %}
  {% elseif replace_0_price_by_text == "true" and item.products.woo_regular_price == "" %}
    {{replace_0_price_text|raw}}
  {% endif %}{# end replace_0_price_by_text #}{##}

  {% if replace_0_price_by_text == "false" %}  
    {{item.products.woo_regular_price|wc_price|raw}}{% if show_text_after_prices == "true" %}{{textAfterPriceElem}}{% endif %}
  {% endif %}
{% endset %}{# end regularProductRegularPriceElem #}{##}

{% set variableProductRegularPriceElem %}
  {% if item.products.woo_regular_price_from == item.products.woo_regular_price_to %}
	  <span class="uc_sale_currency">{{regularProductRegularPriceElem}}</span> 
  {% else %}              
    {% if show_only_lowest_variable_price == "true" %}
	  <span class="uc_sale_currency">{{before_lowest_price_text|raw}}{{item.products.woo_regular_price_from|wc_price(item.products.woo_regular_price_from_id)|raw}}{% if show_text_after_prices == "true" %}{{textAfterPriceElem}}{% endif %}</span>
    {% else %}
      <span class="uc_sale_currency">{{item.products.woo_regular_price_from|wc_price|raw}}{% if show_text_after_prices == "true" %}{{textAfterPriceElem}}{% endif %}</span> - <span class="uc_sale_currency">{{item.products.woo_regular_price_to|wc_price|raw}}{% if show_text_after_prices == "true" %}{{textAfterPriceElem}}{% endif %}</span>
    {% endif %}{# end show_only_lowest_variable_price #}{##}
  {% endif %}{# end item.products.woo_regular_price_from == item.products.woo_regular_price_to #}{##}
{% endset %}{# end variableProductRegularPriceElem #}{##}

{% set regularProductSalePriceElem %}
  {% if replace_0_price_by_text == "true" and item.products.woo_sale_price != "" %}
    {{item.products.woo_sale_price|wc_price|raw}}{% if show_text_after_prices == "true" %}{{textAfterPriceElem}}{% endif %}
  {% elseif replace_0_price_by_text == "true" and item.products.woo_sale_price == "" %}
    {{replace_0_price_text|raw}} 
  {% endif %}

  {% if replace_0_price_by_text == "false" and item.products.woo_sale_price != "" %}              
    {{item.products.woo_sale_price|wc_price|raw}}{% if show_text_after_prices == "true" %}{{textAfterPriceElem}}{% endif %}         
  {% endif %}
{% endset %}{# end regularProductSalePriceElem #}{##}

{% set variableProductSalePriceElem %}
  {% if item.products.woo_sale_price_from == item.products.woo_sale_price_to %}	
      {{regularProductSalePriceElem}}  
  {% else %}  	
    {% if show_only_lowest_variable_price == "true"%}
	  {{before_lowest_price_text|raw}}{{item.products.woo_sale_price_from|wc_price|raw}}{{text_after_prices|raw}}
    {% elseif show_only_lowest_variable_price == "false" %}
      {{item.products.woo_sale_price_from|wc_price|raw}}{% if show_text_after_prices == "true" %}{{textAfterPriceElem}}{% endif %}  - {{item.products.woo_sale_price_to|wc_price|raw}}{% if show_text_after_prices == "true" %}{{textAfterPriceElem}}{% endif %}
    {% endif %} {# end show_only_lowest_variable_price #}{##}
  {% endif %}{# end item.products.woo_price_from == item.products.woo_price_to #}{##}
{% endset %}{# end variableProductSalePriceElem #}{##}

{% set loaderElem %}
  <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="20" viewBox="0 0 32 32">
    <g stroke-width="1" transform="translate(0.5, 0.5)">
      <g class="nc-loop-bars-rotate-32-icon-o" stroke-width="1">
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="31" x2="26" y1="16" y2="16" stroke-linejoin="miter"></line>
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="26.607" x2="23.071" y1="26.607" y2="23.071" opacity="0.4" stroke-linejoin="miter"></line>
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="16" x2="16" y1="31" y2="26" opacity="0.4" stroke-linejoin="miter"></line>
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="5.393" x2="8.929" y1="26.607" y2="23.071" opacity="0.4" stroke-linejoin="miter"></line>
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="1" x2="6" y1="16" y2="16" opacity="0.4" stroke-linejoin="miter"></line>
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="5.393" x2="8.929" y1="5.393" y2="8.929" opacity="0.4" stroke-linejoin="miter"></line>
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="16" x2="16" y1="1" y2="6" opacity="0.6" stroke-linejoin="miter"></line>
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="26.607" x2="23.071" y1="5.393" y2="8.929" opacity="0.8" stroke-linejoin="miter"></line>
      </g>
      <style stroke-width="1">
        .nc-loop-bars-rotate-32-icon-o{
          --animation-duration:0.8s;
          transform-origin:16px 16px;
          animation:nc-loop-bars-rotate-anim var(--animation-duration) infinite steps(8,jump-start)
        }
        @keyframes nc-loop-bars-rotate-anim{
          0%{
            transform:rotate(0)
          }
          100%{
            transform:rotate(360deg)
          }
        }
      </style>
    </g>
</svg>
{% endset %}{# end loaderElem #}{##}

{% set productAttributes = ucfunc("get_product_attributes",item.products.id) %} {# returns product attributes #}{##}
{# end twig vars #}{##}

<div class="uc_post_grid_style_one_item ue-item" id="{{item.item_id}}">
   
  {% if before_shop_loop_item == "true" %} 
  	{{do_action("woocommerce_before_shop_loop_item")}}
  {% endif %}  
 
  {% if enable_third_party_integrations == "true" %}
   	{{do_action('ue_woocommerce_product_integrations', item.products.id)}}
  {% endif %}   
  
  {% if show_image == "true" %}
    <div class="uc_post_grid_style_one_image-wrapper">
      <a class="uc_post_grid_style_one_image {{item.products.dynamic_popup_link_class__image}}" {{item.products.dynamic_popup_link_attributes__image|raw}}>     

        <div class="uc_post_image"> 
          {% if item.products.image is empty %}
            {{defaultImageElem}}
          {% else %}
            <img src="{{item.products.image}}"  alt="{{item.products.image_alt}}">
          {% endif %}	
            
          {% if show_labels == "true" %}{{labelsElem}}{% endif %} 
        </div>{# end uc_post_image #}{##}

        {% if swap_image_on_hover == "true" %}
          {% if urlImage2 is not empty %}     
            <div class="uc_post_image uc_post_image--second">
              <img src="{{urlImage2}}" alt="{{item.products.image_alt}}">
            </div>{# end uc_post_image--second #}{##}
          {% endif %}
        {% endif %}

      </a>{# end uc_post_grid_style_one_image #}{##}
    </div>{# end uc_post_grid_style_one_image-wrapper #}{##} 
  {% endif %}{# end show_image #}{##}
  
  {% if grid_item_as_product_link == "true" %}
  	<a class="uc_content-link" href="{{item.products.link}}"></a>
  {% endif %}    
  
  <div class="uc_content padding">
    
      {% if(show_labels == "true") and (show_image == "false") %}
          {% if(item.products.woo_stock_status == "outofstock") %}{{outOfStockLabelElem}}{% endif %}
      {% endif %}
   
      {% if show_label_from_custom_field_ == "true" %}   
		{% if custom_field_value is not empty %}
		  <div class="ue_woocommerce_product_label ue_woocommerce_product_label-custom-field">{{custom_field_value|raw}}</div>
        {% endif %}
      {% endif %}{# end show_label_from_custom_field_ #}{##}
    
      {% if show_category == "true" %}
        <div class="ue_category_wrapper">
          {% if show_all_categories == "false" %}
            <a class="ue_category_label" href="{{item.products.category_link}}">{{item.products.category_name}}</a>
          {% else %}
            {% for cat in item.products.categories %}
              <a class="ue_category_label" href="{{cat.link}}">{{cat.name}}</a>
            {% endfor %}
          {% endif %}
        </div>{# end ue_category_wrapper #}{##}
      {% endif %}{# end show_category #}{##}
    
      {% if before_shop_loop_item_title == "true" %} 
        {{do_action("woocommerce_before_shop_loop_item_title")}}
      {% endif %}
    
      {% if show_title == "true" %}<{{title_html_tag}} class="uc_title"><a href="{{item.products.link}}">{{item.products.title|raw}}</a></{{title_html_tag}}>{% endif %}
    
      {% if after_shop_loop_item_title == "true" %} 
        {{do_action("woocommerce_after_shop_loop_item_title")}}
      {% endif %}
    
      {% if show_sku == "true" %}<div class="uc_title uc_sku_title">{{item.products.woo_sku}}</div>{% endif %}      
      {% if show_short_description == "descr" %}<div class="ue-description">{{item.products.intro|raw }}</div>{% endif %}
      {% if show_short_description == "descr_tags" %}<div class="ue-description">{{item.products.excerpt|raw }}</div>{% endif %}
      {% if (show_rating == "true") and (rating_position == "after_title") %}{{ratingElem}}{% endif %}
      
      <div class="ue_grid_item_bottom">
      
       <div class="ue_grid_prices">         
         {% if show_regular_price == "true" and item.products.woo_sale_price is not empty %}         
           <div class="uc_regular_price">
             {% if item.products.woo_type == "variable" %}
			   {{variableProductRegularPriceElem}}
             {% else %}
                {{regularProductRegularPriceElem}}           
             {% endif %}              
           </div>{# end uc_regular_price #}{##}
         {% elseif show_regular_price == "true" and item.products.woo_sale_price is empty %}
           <div class="uc_regular_price uc_regular_price--single">
             {% if item.products.woo_type == "variable" %}
			   {{variableProductRegularPriceElem}}
             {% else %}
                {{regularProductRegularPriceElem}}           
             {% endif %}              
           </div>{# end uc_regular_price #}{##}
         {% endif %}
        
         {% if show_sale_price == "true" %}
        	<div class="uc_price">
              {% if item.products.woo_type == "variable" %}
                {{variableProductSalePriceElem}}
              {% else %}
                {{regularProductSalePriceElem}}         
             {% endif %}              
         	</div>{# end uc_price #}{##}
         {% endif %}         
       </div>{# end ue_grid_prices #}{##}
	  
      <div class="uc_post_grid_style_one_button">
        {% if show_product_button == "true" %}                        
              <a class="uc_more_btn {{item.products.dynamic_popup_link_class}}" href="{{item.products.link}}" {{item.products.dynamic_popup_link_attributes|raw}} target="{{open_product_in_new_tab}}">
                <div class="ue-inner-btn-wrapper"><span>{{product_button_icon_html|raw}}</span><span>{{procut_button_text|raw}}</span></div>
              </a>{# end uc_more_btn #}{##}        
        {% endif %}

        {% if show_add_to_cart_button == "true" and (item.products.woo_stock_status != "outofstock") %}
        
          {% if item.products.woo_type == "variable" %}
              <a class="ue-variable-btn" href="{{item.products.link}}">
                <div class="ue-inner-btn-wrapper"><span>{{product_button_icon_html|raw}}</span><span>{{variable_button_text|raw}}</span></div>
              </a>{# end ue-variable-btn #}{##}
          {% else %}
        
            {% if show_count_buttons == "true" %}
              <div class="uc-grid-count-buttons">
                <button class="uc-grid-count-buttons__minus" disabled>{{quantity_minus_html|raw}}</button>
                  <input type="text" class="uc-grid-count-buttons__number" value="1">
                  <button class="uc-grid-count-buttons__plus" >{{quantity_plus_html|raw}}</button>
                </div>
            {% endif %}{# end show_count_buttons #}{##}

            <button {{item.products.woo_addcart_ajax_attributes|raw}}>
              <div class="ue-inner-btn-wrapper">
                <span>{{add_to_cart_button_icon_html|raw}}</span>
                <span>{{add_to_cart_button_text|raw}}</span>                     
                <span class="add-to-cart__loader" style="display:none">{{loaderElem}}</span> 
              </div>{# end ue-inner-btn-wrapper #}{##}
            </button>  
         	
          {% endif %}{# end non-variable product add to cart elem #}{##}
        {% endif %}{# end show_add_to_cart_button #}{##}
        
        {% if show_additional_button == "true" %}        
          {% set custom_field_link = ucfunc("get_post_custom_field", item.post_list.id, additional_button_link_custom_field)%} 
        
          <a class="uc_more_btn-custom-field" href="{{custom_field_link}}" target="{{additional_button_open_type}}">
            <div class="uc_btn_inner"><div class="uc_btn_txt">{{additional_button_text|raw}}</div></div>
          </a>{# end uc_more_btn-custom-field #}{##}
        {% endif %}{# end show_additional_button #}{##}
        
        {% if (show_rating == "true") and (rating_position == "after_cart") %}{{ratingElem}}{% endif %}
      </div>
    </div> 
  </div>

  {% if after_shop_loop_item == "true" %} 
    {{do_action("woocommerce_after_shop_loop_item")}}
  {% endif %}  	

</div>