<?php
/*
Plugin Name: Custom Functions Plugin
Description: A plugin to add custom functions through a separate dashboard page with database storage.
Version: 1.0
Author: <a href="https://luvcite.com">LuvCite Technology</a>
*/

//Create the database table on plugin activation
register_activation_hook(__FILE__, 'custom_functions_plugin_activate');
function custom_functions_plugin_activate() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'custom_functions';
    
    // Check if the table already exists
    if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
        // Table does not exist, so create it
        $charset_collate = $wpdb->get_charset_collate();
        $sql = "CREATE TABLE $table_name (
            id mediumint(9) NOT NULL AUTO_INCREMENT,
            custom_code longtext NOT NULL,
            PRIMARY KEY  (id)
        ) $charset_collate;";
        
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
}

//Delete the table on plugin uninstallation
register_uninstall_hook(__FILE__, 'custom_functions_plugin_uninstall');
function custom_functions_plugin_uninstall() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'custom_functions';
    
    // Drop the table
    $wpdb->query("DROP TABLE IF EXISTS $table_name");
}

//Add a menu item for the custom functions dashboard
add_action('admin_menu', 'custom_functions_plugin_menu');
function custom_functions_plugin_menu() {
    add_menu_page(
        'Custom Functions',           // Page title
        'Custom Functions',           // Menu title
        'manage_options',             // Capability (only admins)
        'custom-functions-dashboard', // Menu slug
        'custom_functions_plugin_page', // Function to display page content
        'dashicons-editor-code',      // Icon
        80                            // Position
    );
}

//Create the admin page with a form to input PHP code
function custom_functions_plugin_page() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'custom_functions';

    // Check if user has the right capability
    if (!current_user_can('manage_options')) {
        return;
    }

    // Handle form submission and save code in the database
    if (isset($_POST['custom_code'])) {
        $custom_code = stripslashes($_POST['custom_code']);
        
        // Check if there is existing code in the table
        $existing_code = $wpdb->get_var("SELECT custom_code FROM $table_name WHERE id = 1");

        if ($existing_code === null) {
            // Insert if no code exists
            $wpdb->insert($table_name, array('custom_code' => $custom_code));
        } else {
            // Update the existing code
            $wpdb->update($table_name, array('custom_code' => $custom_code), array('id' => 1));
        }

        echo '<div class="updated"><p>Code saved successfully!</p></div>';
    }

    // Get saved code from the database
    $saved_code = $wpdb->get_var("SELECT custom_code FROM $table_name WHERE id = 1");
    if (!$saved_code) {
        $saved_code = '';
    }

    ?>
    <div class="wrap">
        <h1>Custom Functions</h1>
        <form method="post">
            <textarea name="custom_code" rows="20" cols="100" style="width:100%;"><?php echo esc_textarea($saved_code); ?></textarea>
            <br><br>
            <input type="submit" value="Save Code" class="button button-primary">
        </form>
    </div>
    <?php
}

//Execute the custom code from the database
add_action('init', 'execute_custom_functions_code');
function execute_custom_functions_code() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'custom_functions';
    
    $custom_code = $wpdb->get_var("SELECT custom_code FROM $table_name WHERE id = 1");
    
    if (!empty($custom_code)) {
        try {
            eval($custom_code); // Be careful using eval()
        } catch (Throwable $e) {
            error_log('Error in custom functions plugin: ' . $e->getMessage());
        }
    }
}

//Enqueue custom scripts and styles
function custom_enqueue_scripts() {
    // Enqueue a custom JavaScript file
    wp_enqueue_script('my-custom-script', plugin_dir_url(__FILE__) . 'js/custom-script.js', array('jquery'), '1.0', true);
    
    // Enqueue a custom CSS file
    wp_enqueue_style('my-custom-style', plugin_dir_url(__FILE__) . 'css/custom-style.css');
}
add_action('wp_enqueue_scripts', 'custom_enqueue_scripts');
