function ueParalaxContentCard(){
  
  //classes
  
  
  //selectors
  
  
  //objects
  var g_objWidget, g_objContent, g_objImage, g_objWrap;
  
  //custom attrs
  var g_resetTimeout, g_cardTilt, g_imageTilt, g_contentTilt;
  
  /**
  * apply parallax
  */
  function applyParallax(e) {
    clearTimeout(g_resetTimeout);
    
    var widgetOffset = g_objWidget.offset();
    var widgetWidth  = g_objWidget.width();
    var widgetHeight = g_objWidget.height();
    
    var mouseX = e.pageX - widgetOffset.left;
    var mouseY = e.pageY - widgetOffset.top;
    
    var percentX = (mouseX / widgetWidth) - 0.5; // -0.5 to 0.5
    var percentY = (mouseY / widgetHeight) - 0.5;
    
    // rotate whole card
    var rotateX = percentY * -g_cardTilt; // invert so it feels natural
    var rotateY = percentX * g_cardTilt;
    
    g_objWrap.css({'transform': 'rotateY(' + rotateY + 'deg) rotateX(' + rotateX + 'deg)'});

    if(g_objImage && g_objImage.length > 0)
    g_objImage.css({'transform': 'translate(' + (percentX * -g_imageTilt) + 'px,' + (percentY * -g_imageTilt) + 'px)'});

    g_objContent.css({'transform': 'translate(' + (percentX * g_contentTilt) + 'px,' + (percentY * g_contentTilt) + 'px)'});
  }
  
  /**
  * reset parallax
  */
  function resetParallax() {
    
    g_resetTimeout = setTimeout(function () {      
      g_objWrap.css({'transform': ''});

      if(g_objImage && g_objImage.length > 0)
      g_objImage.css({'transform': ''});

      g_objContent.css({'transform': ''});
      
    }, 1000);
  }  
  
  /**
  * init from external file
  */
  this.init = function(options){
    
    //init vars
    var widgetId = options.widgetID;
    g_cardTilt = options.cardTilt;
    g_imageTilt = options.imageTilt;
    g_contentTilt = options.contentTilt;
    //classes
    
    
    //selectors
    
    
    //objects
    g_objWidget = jQuery('#'+widgetId);
    g_objWrap = g_objWidget.find(".ue-3d-content-card-wrap")
    g_objContent = g_objWidget.find('.ue-3d-content-card-content'); // Example class
    g_objImage = g_objWidget.find('.ue-3d-content-card-img');
    
    //custom attrs
    
    
    //init events
    g_objWidget.on('mousemove', function(e) {
      applyParallax(e);
    });
    
    g_objWidget.on('mouseleave', function() {
      resetParallax();
    });
  }
  
}