<div id="{{uc_id}}" class="ue-hover-image-video" {% if debug_hover_state == "true" and (uc_inside_editor == "yes") %}data-debug="true"{% endif %}>
  <img class="ue-image" src="{{image}}" alt="{{image_alt}}" {{image_attributes|ucsafe|raw}}>
  {% if video_source == "html5video" %}
    <video class="ue-video" preload="metadata" muted playsinline loop>
      <source src="{% if video_url is not empty %}{{video_url}}{% else %}{{uc_assets_url}}/demo-video.mp4{% endif %}" type="video/mp4" />
    </video>
  {% endif %}
  {% if video_source == "vimeo" %}
    <iframe
      class="ue-video"
      src="https://player.vimeo.com/video/{{vimeo_video_id|ucsafe|raw}}?background=1&autoplay=1&muted=1&loop=1&title=0&byline=0&portrait=0"
      frameborder="0"
      allow="autoplay; fullscreen"
      >
    </iframe>
  {% endif %}
  {% if show_overlay == "true" %}
    <div class="ue-overlay">
      {% if show_overlay_icon == "true" %}<span class="ue-overlay-icon" role="img" aria-hidden="true">{{overlay_icon_html|ucsafe|raw}}</span>{% endif %}
    </div>
  {% endif %}
  {% if show_button == "true" %}
    <a class="ue-button" href="{{link}}" {{link_html_attributes|ucsafe|raw}}>
      {{button_label|ucsafe|raw}}
      {% if show_button_icon == "true" %}{{button_icon_html|ucsafe|raw}}{% endif %}
    </a>
  {% endif %}
</div>