#{{uc_id}} * {
	box-sizing: border-box;	
}

#{{uc_id}} .uc_post_grid_style_one_wrap {
	display: grid;
}

#{{uc_id}} .uc_post_grid_style_one_image {
	width: 100%;
	overflow: hidden;
	display: block;  	
}

#{{uc_id}} .uc_post_image {
	width: 100%;
	height: inherit;
	background-position: center center;
	background-repeat: no-repeat;
	display: block;
	transition: all 0.25s ease-in-out;
}

#{{uc_id}} .ue-image-holder a{
  display:block;
}

#{{uc_id}} .ue-item{
  position:relative;
  overflow:hidden;
}

#{{uc_id}} .ue-item .uc_post_grid_style_one_item_full_item_link{
  position: absolute;
  width: 100%;
  height: 100%;
  left: 0;
  top: 0;
}

#{{uc_id}} .ue-item-title{
  width:100%;
}

#{{uc_id}} .ue-item-text{
  width:100%;
}

#{{uc_id}} .uc_content{
  display:flex;
  flex-direction:column;
}

#{{uc_id}} .ue-content-wrapper{
  width:100%;
}

#{{uc_id}} .ue-button{
  margin-top:auto;
}

#{{uc_id}} .ue-button{
  width:100%;
}

{% if show_button == "true" %}
  #{{uc_id}} a.uc_more_btn{
      align-items: center;
      justify-content: center;
      text-align: center;
      transition: all 0.25s ease-in-out;
  }
  {% if show_icon_button == "true" %}
    #{{uc_id}} a.uc_more_btn svg{
       width:1em;
       height:1em;
    }
  {% endif %}
{% endif %}

{% if layout == "overlay" %}
	#{{uc_id}}.uc_post_grid_style_one .uc_content{
      position:absolute;
      top:0px;
      left:0px;
      bottom:0px;
      right:0px;
      opacity:0;
      transition:1s;
      display:flex;
      align-items:center;
      flex-direction:column;
      justify-content: center;
    }

	#{{uc_id}} .uc_post_grid_style_one_item:hover .uc_content{
      opacity:1;
    }
{% endif %}

{% if layout == "partial_overlay" %}
	#{{uc_id}}.uc_post_grid_style_one .uc_content{
     position:absolute;
     bottom:{{content_margin}}px;
     left:{{content_margin}}px;
     right:{{content_margin}}px;
    }
{% endif %}

{% if layout == "under_overlap" %}
	#{{uc_id}}.uc_post_grid_style_one .uc_content{
     margin-left:20px;
      margin-right:20px;
      margin-top:-30px;
      position:relative;
    }
{% endif %}

{% if layout == "reveal_from_bottom" %}
	#{{uc_id}}.uc_post_grid_style_one .uc_content{
        margin-left:0px;
        margin-right:0px;
        margin-top:0px;
        position:absolute;
      	bottom: -100%;
        left: 0;
        right: 0;
        transition: ease-in-out all 0.25s;
      	-webkit-transition: ease-in-out all 0.25s;
    }
    #{{uc_id}}.uc_post_grid_style_one .uc_post_grid_style_one_item:hover .uc_content{
		bottom: 0;
    }
{% endif %}


{% if layout == "side_by_side" %}
	#{{uc_id}} .ue-item    {
      display:flex;
      {% if flip_side_by_side == "true" %}
      flex-direction:row-reverse;
      {% endif %}
    }

	#{{uc_id}} .uc_content    {
      display:flex;
      justify-content:center;
      flex-direction:column;
      flex-shrink:0;
      flex-grow:0;
    }

    #{{uc_id}} .ue-image-holder    {
      flex-grow:1;
    }
	
{% endif %}


#{{uc_id}}.uc-remote-parent .ue-item{
  cursor:pointer;
}

#{{uc_id}} .uc_post_grid_style_one_search_wrap{
  display: flex;  
}

#{{uc_id}} .uc_post_grid_style_one_search_container{
  position: relative;
}

{% if disable_search_outline == "true" %}
#{{uc_id}} .uc_post_grid_style_one_search_input:focus{
  outline: none;
}
{% endif %}

#{{uc_id}} ::-webkit-input-placeholder { /* Edge */
  color: {{search_placeholder_color}};
}

#{{uc_id}} :-ms-input-placeholder { /* Internet Explorer 10-11 */
  color: {{search_placeholder_color}};
}

#{{uc_id}} ::placeholder {
  color: {{search_placeholder_color}};
}

#{{uc_id}} .uc_post_grid_style_one_next_button_pagination_button{
  {% if show_prev_next_page_button == "false" %}
    display: none;
  {% endif %}
}

#{{uc_id}} .uc_post_grid_style_one_search_icon,
#{{uc_id}} .uc_post_grid_style_one_reset_icon{
	position: absolute;
  	top: 50%;
    transform: translate(0, -50%);
    height: 100%;
  	display: flex;
    align-items: center;
    justify-content: center;
}

#{{uc_id}} .uc_post_grid_style_one_reset_icon{
  cursor: pointer;
}

{% if debug_reset_icon == "true" and uc_inside_editor == "yes" %}
  #{{uc_id}} .uc_post_grid_style_one_search_icon{
    display: none;
  }
  #{{uc_id}} .uc_post_grid_style_one_reset_icon{
    display: flex !important;
  }
{% endif %}

/* pagination */
#{{uc_id}} .uc_post_grid_style_one_prev_button_pagination{
  display: flex;
  align-items: center;
}

#{{uc_id}} .uc_post_grid_style_one_pagination_button,
#{{uc_id}} .uc_post_grid_style_one_pagination_number{
  padding: 0;
  justify-content: center;
  align-items: center;
  transition: all .3s ease;
  margin: 0;
}

#{{uc_id}} .uc_post_grid_style_one_pagination_number:last-child,
#{{uc_id}} .uc_post_grid_style_one_pagination_number:first-child{
  display: inline-flex;
  position: relative;
}

#{{uc_id}} .ue-hidden{
  display: none;
}

#{{uc_id}} .ue-disabled{
  opacity: .5;
  pointer-events: none;
}

#{{uc_id}} .uc_post_grid_style_one-link-lightbox{
  cursor: pointer;
}

#{{uc_id}} .uc_post_grid_style_one_pagination_number.ue-visible{
  display: inline-flex;
}

#{{uc_id}} .uc_post_grid_style_one_pagination_numbers{
  display: flex;
  flex-wrap: wrap;
}

#{{uc_id}} .uc_post_grid_style_one_prev_button_pagination_wrap{
  display: flex;
}
/* end pagination */

/* lightbox */

.fancybox-button,
.fancybox-button svg path{	
  color: {{navigation_icons_color}};
}
.fancybox-button{
  background-color: {{navigation_icons_background_color}};
}

.fancybox-button:hover,
.fancybox-button:hover svg path{	
  color: {{navigation_icons_color_hover}};
}
.fancybox-button:hover,
.fancybox-button:focus{
  background-color: {{navigation_icons_background_color_hover}};
}

.fancybox-bg{
  background: {{overlay_background_color}};
}

.fancybox-is-open .fancybox-bg{
  opacity: {{overlay_opacity}} !important;
}

{% if show_lightbox_counter == "false" %}
  .fancybox-infobar{
	display: none !important;
  }
{% endif %}	

{% if show_lightbox_zoom_button == "false" %}
  .fancybox-button--zoom{
	display: none !important;
  }
{% endif %}	

{% if show_lightbox_slideshow_button == "false" %}
  .fancybox-button--play{
	display: none !important;
  }
{% endif %}	

{% if show_lightbox_thumbnails_button == "false" %}
  .fancybox-button--thumbs{
	display: none !important;
  }
{% endif %}	

{% if show_lightbox_close_button == "false" %}
  .fancybox-button--close{
	display: none !important;
  }
{% endif %}	

{% if show_lightbox_arrows == "false" %}
  .fancybox-navigation{
	display: none !important;
  }
{% endif %}

.fancybox-caption__body{
  color: {{item_title_in_lightbox_color}};
}

/* end lightbox */